unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ShellApi,
  Menus;

const
  WM_TRAYICON = WM_USER+1;

type
  TForm1 = class(TForm)
    PopupMenu1: TPopupMenu;
    Opo11: TMenuItem;
    Opo21: TMenuItem;
    Sair1: TMenuItem;
    N1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Sair1Click(Sender: TObject);
  private
    procedure WMTrayIcon(var Msg : TMessage); message WM_TRAYICON;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  NotifyIconData : TNotifyIconData;
begin
  Application.ShowMainForm := False;
  with NotifyIconData do begin
    cbSize := sizeof(TNotifyIconData);
    Wnd := Self.Handle;
    uId := 0;
    uCallBackMessage := WM_TRAYICON;
    uFlags := NIF_ICON or NIF_TIP or NIF_MESSAGE;
    hIcon := Application.Icon.Handle;
    szTip := 'Teste cone';
  end;
  Shell_NotifyIcon(NIM_ADD,@NotifyIconData);
end;

procedure TForm1.FormDestroy(Sender: TObject);
var
  NotifyIconData : TNotifyIconData;
begin
  with NotifyIconData do begin
    cbSize := sizeof(TNotifyIconData);
    Wnd := Self.Handle;
    uId := 0;
    uFlags := 0;
  end;
  Shell_NotifyIcon(NIM_DELETE,@NotifyIconData);
end;

procedure TForm1.WMTrayIcon(var Msg: TMessage);
var
  Pt : TPoint;
begin
  if Msg.lParam = WM_RBUTTONDOWN then begin
    GetCursorPos(Pt);
    PopupMenu1.Popup(Pt.X,Pt.Y);
  end
  else if Msg.lParam = WM_LBUTTONDBLCLK then
    Form1.Show;  
end;

procedure TForm1.Sair1Click(Sender: TObject);
begin
  Close;
end;

end.
